---
# For HTML, PDF:
#title: "A Short History of Drabble"
#author: "Matthias C. Hormann"
# For EPUB:
title:
- type: main
  text: A Short History of Drabble
  file-as: Short History of Drabble, A
- type: subtitle
  text: All in a Hundred Words
- type: edition
  text: '2nd Edition'
creator:
- role: author
  text: Matthias C. Hormann
  file-as: Hormann, Matthias C.
publisher: Self-published
rights: Copyright © 2021 Matthias C. Hormann, CC-BY-NC
date: 2021-01-19
# TBD: The real ISBN (this is just a fake for testing)
identifier:
- scheme: ISBN-13
  type: isbn-id
  text: 9781234567897
lang: en-US
description: |
  What is a Drabble, and its history.
# subject goes into Calibre’s "tags"
subject:
- Test
- EPUB
- E-Book
- Drabble
belongs-to-collection: Tests
group-position: 3.0
cover-image: "A Short History of Drabble.jpg"
# css: "none.css"
#
# pandoc -f commonmark_x -t epub --standalone --toc=true -o 'A Short History of Drabble.epub' 'A Short History of Drabble - YAML.md' 
...

# A Short History of Drabble

## History

A drabble runs to exactly 100 words (the title may or may not be excluded) and is named for a joke game in Monty Python's Big Red Book (anth 1971), based on the television comedy series Monty Python's Flying Circus (1969-1974).

This form became popular in sf circles: one hundred, many by sf authors from Brian Aldiss to Gene Wolfe, were collected as The Drabble Project (coll 1988) edited by Rob Meades and David B Wake, which was sold for one hundred shillings (£5.00) and had two follow-up volumes. Drabbles were welcomed by the British Science Fiction Association's Focus and in Farthing.


## Criteria

A literary work will be considered a *drabble* if it has:

- Exactly 100 words—no more and no less;
- A setting;
- One or more characters;
- Some conflict; And
- A resolution. *(Not limited to the moral of the story)*

The title of the story is not part of the overall word count, but cannot exceed 15 words.


## How to Write a Drabble

A drabble is a short form of fiction that is exactly 100 words long (not including the title). Along with being a lot of fun, their short form can also encourage people who've never written anything before to just give it a try, but writing a coherent and engaging story in just 100 words is very challenging.

### Writing Drabbles

A drabble is like any story, it should have a beginning, a middle and an end. The beginning sets up the story, the middle is the meat (the progression of the story) and the end provides the conclusion. Many of the best drabbles have a twist in the tale — the start and middle will take you in an expected direction and then the end turns that around.

In many ways this is similar to the traditional structure of a joke, the scene is set, something happens and then it is turned around to surprise the audience. This works well with the short form of the drabble. Even better, when the end not only surprises but causes the reader to re-evaluate the start and middle with new understanding.

### How do you fit a story in so few words?

The first draft is rarely anywhere close to being 100 words and like any writing, it's also very rare that this first version is worth sharing, so editing is key to getting the required word count.

This is also a useful aspect for developing your skills as a writer, as the strict word count teaches you how to be economical with your words. Once you have a first draft, read through it, if you're only a dozen or so words out then it's a case of picking the right words for the job.

> Strip out anything that isn't needed. Like any editing, you need to be brutal, but not so severe that the core message of the story is lost.

If you're further away from the word count then you'll need to look at removing whole sentences — as with the stray words, remove anything that isn't core to the story you're telling.

The scope of a story can still be quite dramatic but there should only be one or two threads to the tale. It is linking disparate elements that tends to bloat your word count, so ask yourself, what is the story that I am telling?

### What should a drabble be about?

The answer is simple, it can be about anything! Drabbles are a form of fiction, it doesn't define what the fiction is about. You can have action stories, erotic or romance, any genre that you enjoy.

Most importantly of all, writing should be done because you enjoy it, developing your craft comes with practice, and drabbles are a fun way to practice it.
